func _start_patch2 {
    { #error if no func lo_version
        float f1 f2
        string s
        readfrom (lo_version) "%f_%f%s" f1 f2 s
        if ( (@f1 > 8.4)  || \
             (@f1 == 8.4 && @f2 > 2.0)) {
            popfile
        }
    Error:
    Popfile:
    }
}
_start_patch2

# patch for opt bug DR 81988
# will be included in train2
# Opt crashes with opt_area twolevel recipe.


func espresso(args option) {
	string espin
	int rc
	string plaout

	espin = (gc_scratchopen espin c)[1]
	wr_pla @espin
	plaout = (gc_scratchopen plaout c)[1]
	if (!@option) (option = "-Dso_both")
	rc = (sys  (cat @Prog.Espresso " "  @option " < " @espin " > " @plaout ))
	if (! @rc) {
		opt_area_rd_pla @plaout
	} 
	sys_unlink @plaout
	sys_unlink @espin
	if @rc (error "espresso failed")
}

func opt_area_rd_pla (args fname) {
        file fp
        int rc
        string  outfile
        fp = (rd_openfile @fname)
        if (! @fp ){
            error Cannot open file @fname for read
        }
        rc = (readesp @fp)
        fclose @fp
        if @rc {
                eprintf "Failed to read pla: %s\n" (errorinfo)
                return ()
        }
        popinv
        makenetcomps
        widegates 3
        lo_removedups @Netlist
        set Newfile 1
/* Fix for crash in twolevel opt */
	lo_sortnetlistports @Netlist
/* sortnetlist ports fixes problem reported as DR84698*/
        lo_postreadnetlist @Netlist
        return @Netlist
}

func rd_pla (args fname) {
	file fp
	int rc 
	string  outfile

	fp = (rd_openfile @fname)
	if (! @fp ){
	    error Cannot open file @fname for read
	}
	lo_clearprops @Netlist._view
	rc = (readesp @fp)
	fclose @fp
	if @rc {
		eprintf "Failed to read pla: %s\n" (errorinfo)
		return ()
	}
	popinv
	makenetcomps
	widegates 3
	lo_removedups @Netlist
	set Newfile 1
/* Fix for crash in twolevel opt */
        lo_sortnetlistports @Netlist
/* sortnetlist ports fixes problem reported as DR84698*/
	lo_postreadnetlist @Netlist
	return @Netlist
}

# DR 92513 workaround
# design explodes with sr latch

func opt_map () {
	abstract instance p # port
	abstract net n
	abstract instance i
	abstract connection c
	abstract library lp
	abstract gatetype tp
	global int Mapcount Mapnet
	int et err
	list umap
	untyped x

#
#	lo_constant_prop @Netlist  # if this is not acceptable, take it out
	lo_optvar_reset

	if @Opt.timingenabled (et = 1)
	Opt.timingenabled = 0
	lo_pruneconstraints @Netlist
	widegates 12
	map_fixsimnodes
	cleanup
	lo_namenets
	if @et (lo_settiming)
	Mapnet = 0
	Mapcount = 0
	println Mapping Combinational Logic
	map_combinational
	println Mapping latches, flipflops and tristate

	opt_area_seq map
	doreplace
	lo_docons @Netlist
	if @et (lo_settiming)
	foreach n (nets @Netlist) {
		if @n.realname (n._name = @n.realname)
	}
	shortgates
	if (@Netlist._maxcap_violations) {
		println "Fixing fanout violations"
		opt_maxbuffer map
	}
	cleanup
	hier_doreplace

	umap = '()
	err = 0
	foreach i (instances @Netlist) {
		tp = @i._gatetype
		lp = @tp._view._cell._library
		if(@lp == @TargetLib) (continue)
		if(@lp == @GflLib && (instr @tp._flags MFCb)) (continue)
		if(! @i._avoid) {
			++ err
			if(!(isinlist @tp @umap)) (prepend umap @tp)
		}
	}
	if @umap {
		eprintf "\n\n!!! %d instances were not mapped\n" @err
		eprintf "Unmapped types: %l\n" (map x @umap (bld @x._gflname))
		eprintf "You may need to create mapping rules for these cells\n"
		eprintf "before continuing.\n\n\n"
	} else {
		println "Mapping Complete"
	}
}


func a_makenlatches(abstract netlist n) {
	abstract instance i
	string t
#
#	with_netlist @n (opt_sr)
	a_matchonelatch_prepass
	foreach i (instances @n) {
		t = @i._gatetype._name
		if (@t == NLATCH) {
			a_makenlatch @i
		} else if (@t == LATCH) {
			if(!(a_matchonelatch @i)) {
				a_extractnlatch @i
			}
			#if(!(a_makelatch @i)) {
			#	a_extractnlatch @i
			#}
		} 
	}
	lo_reclaimsigs
}
# =========================================================================
func wrapportmods(abstract netlist _nl; executable _Ev) {
#
# This is a wrapper for modifications of the port names
# or addition/deletion of ports of a netlist.  The problem
# is that the connections on the parent instance are connected
# by order and the parent instance needs to be updated.
#
	abstract instance _ip _ipp
	list _plist _plist1 _cplist _proplist _pp _cpp _lookup
	string _name _pname _lpname
	abstract view _instof _nlv
	abstract netlist _pnl
	abstract connection _cn
	abstract net _np

	_nlv = @_nl._view
	_ip = @_nlv._parent
	if (! @_ip) {
		eval (bld @_Ev)		# hack!
		lo_sortnetlistports @_nl
		return
	}
	_plist1 = _cplist = '()
	foreach _cn (conns @_ip) {
		prependnc _plist1 (bld @_cn._portname @_cn._net)
		_cpp <- @_cn._proplist
		if @_cpp (prependnc _cplist (bld @_cn._portname @_cpp))
	}
	foreach _ipp (ports @_nl) {
		_ipp.%keepportname = @_ipp._portname
	}
	_proplist = @_ip._proplist
	if @_ip._donttouch (prependnc _proplist '(_donttouch 1))

	_name = @_ip._name
	_instof = @_ip._instof
	_pnl = @_ip._netlist
	eval (bld @_Ev)		# hack!
	lo_sortnetlistports @_nl
	deleteabs @_ip

	# figure out the new port list.  We have to remove
	# references to ports that don't exist and add ones for new ports
	# and keep track of which ports may have changed names
	_plist = '()
	_lookup = '()
	foreach _ip (ports @_nl) {
		_lpname = @_ip.%keepportname
		_ip.%keepportname = '()
		_pname = @_ip._portname
		if(isnull @_lpname) (_lpname = @_pname)
		_lookup.@_lpname = @_pname
		_np <- @_plist1.@_lpname
		if(! @_np) (_np = (addnet @_pnl))
		prependnc _plist (bld @_pname @_np)
	}
	_ip = (addinstance @_pnl @_instof @_plist)
	_nlv._parent = @_ip

	# if it was named, restore name
	if(@_name != "$UNNAMED") (_ip._name = @_name)

	# restore instance properties
	foreach _pp @_proplist {
		_pname = @_pp[0]
		_ip.@_pname <- @_pp[1]
	}

	# now restore connection properties
	foreach _cpp @_cplist {
		_lpname = @_lookup.(@_cpp[0])
		_cn = (catch () findconn @_ip @_lpname)
		if @_cn {
			foreach _pp @_cpp[1] {
				_pname = @_pp[0]
				_cn.@_pname = @_pp[1]
			}
		}
	}
}

func hier_walk_r(abstract netlist _nl) {
	abstract instance _i
	abstract view _v
	abstract netlist _keepnl
	list _mods

	_mods = '()
	foreach _i (modules @_nl) {
		prepend _mods @_i
	}
	foreach _i @_mods {
		hier_walk_r @_i._instof._netlist
		continue
	Error:
		println corrupt instance handle
	}
	_keepnl = @Netlist
	set Netlist @_nl
	eval @_Eval
	Netlist = @_keepnl
}
